document.addEventListener("DOMContentLoaded", function() {
    const Container = document.getElementById("Container");
    const loadMoreButton = document.getElementById("load-more-btn");
    const cards = Container.querySelectorAll(".card");

    let currentIndex = 0;
    cards.forEach(card => {
        card.classList.add("hidden");
    });

    showNextPosts();

    function showNextPosts() {
        for (let i = currentIndex; i < currentIndex + 3 && i < cards.length; i++) { //how may cards show on page
            cards[i].classList.remove("hidden");
        }

        currentIndex += 3; // how may more cards add on the page 

        if (currentIndex >= cards.length) {
            loadMoreButton.style.display = "none"
        }
    }

    loadMoreButton.addEventListener("click", function() {
        showNextPosts();
    });
});